/****** Object:  StoredProcedure [dbo].[P_CG_FND_VERBA_ANALISE_SALDOS]    Script Date: 23/05/2014 11:35:40 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_CG_FND_VERBA_ANALISE_SALDOS]') 
					AND type in (N'P', N'PC'))
	BEGIN
		DROP PROCEDURE [DBO].[P_CG_FND_VERBA_ANALISE_SALDOS]
	END
GO
GO
CREATE PROCEDURE P_CG_FND_VERBA_ANALISE_SALDOS (@CD_EMP INT=1, @CD_FND_VERBA INT=0) 
AS
CREATE TABLE #RsTable (CD_EMP INT,CD_FND_VERBA INT, VLR_RECB MONEY)
INSERT INTO #RsTable
SELECT
	CG_FND_VERBA.CD_EMP,
	CG_FND_VERBA.CD_FND_VERBA,
	ISNULL(SUM(CG_FND_VERBA_RECB.VLR_RECB),0)
FROM
	CG_FND_VERBA LEFT OUTER JOIN CG_FND_VERBA_RECB ON
	CG_FND_VERBA.CD_EMP = CG_FND_VERBA_RECB.CD_EMP AND
	CG_FND_VERBA.CD_FND_VERBA =CG_FND_VERBA_RECB.CD_FND_VERBA
WHERE
	CG_FND_VERBA.CD_EMP = @CD_EMP
	AND CG_FND_VERBA.CD_FND_VERBA = CASE WHEN @CD_FND_VERBA=0 THEN CG_FND_VERBA.CD_FND_VERBA ELSE @CD_FND_VERBA END
GROUP BY
	CG_FND_VERBA.CD_EMP,
	CG_FND_VERBA.CD_FND_VERBA,
	CG_FND_VERBA.VLR_LANC,
	CG_FND_VERBA.VLR_RECB

UPDATE
	CG_FND_VERBA
SET 
	CG_FND_VERBA.VLR_RECB = R.VLR_RECB
FROM
	CG_FND_VERBA INNER JOIN #RsTable R ON
	CG_FND_VERBA.CD_EMP = R.CD_EMP AND
	CG_FND_VERBA.CD_FND_VERBA =R.CD_FND_VERBA

DROP TABLE #RsTable;